/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/* This file is included by cfiles_<kernopts>.c
 * It is a list of c files that make up the mmfslinux
 * module.  The cfiles_<kernopts>.c file includes the
 * <linux/config.h> that is on the local machine and redefines
 * the kernel config options.  It then includes this file.
 *  
 * The reason for this is so we can build a module for an alternate
 * kernel config.
 */ 
#include "block.c"
#include "dir.c"
#include "kx.c"
#include "mmap.c"
#include "ss.c"
#include "super.c"
#ifdef CONFIG_NSS
#include "cred.c"
#endif
#ifdef SMB_LOCKS
#include "oplock.c"
#endif
#include "inode.c"
#include "file.c"
#include "cxiVFSStats.c"
#include "cxiSystem.c"
#include "cxiIOBuffer.c"
#include "gplInit.c"

/* Define variables to be exported based on kernel configuration.
   These can then be detected via "nm" in order to verify that the
   module that is to be loaded matches the running kernel. */

#if defined(CONFIG_HIGHMEM)
# if defined(CONFIG_HIGHMEM4G)
    int GPFS_CONFIG_HIGHMEM4G = 1;
    EXPORT_SYMBOL(GPFS_CONFIG_HIGHMEM4G);
# endif
# if defined(CONFIG_HIGHMEM64G)
    int GPFS_CONFIG_HIGHMEM64G = 1;
    EXPORT_SYMBOL(GPFS_CONFIG_HIGHMEM64G);
# endif
#endif

#if defined(CONFIG_SMP)
  int GPFS_CONFIG_SMP = 1;
  EXPORT_SYMBOL(GPFS_CONFIG_SMP);
#endif

#if defined(GPFS_ARCH_IA64)
  int GPFS_CONFIG_IA64 = 1;
  EXPORT_SYMBOL(GPFS_CONFIG_IA64);
#endif

/* Compiled for different PAGE_OFFSETs */
#if defined(CONFIG_1GB)
  int GPFS_CONFIG_1GB = 1;
  EXPORT_SYMBOL(GPFS_CONFIG_1GB);
#elif defined(CONFIG_2GB)
  int GPFS_CONFIG_2GB = 1;
  EXPORT_SYMBOL(GPFS_CONFIG_2GB);
#elif defined(CONFIG_3GB)
  int GPFS_CONFIG_3GB = 1;
  EXPORT_SYMBOL(GPFS_CONFIG_3GB);
#endif
